// Jasmine Unit Testing Suite
define([
    'backbone',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-date-collection',
], function (Backbone, TimeSlotsByDateCollection) {
    'use strict';

    describe('Time Slots by Date Collection', function () {
        var collection;

        beforeEach(function () {
            collection = new TimeSlotsByDateCollection([
                {date: '12/03/2014'},
                {date: '12/06/2014'},
                {date: '12/04/2014'},
            ]);
        });

        it('sorts models chronologically by date', function () {
            expect(collection.at(0).get('date')).toEqual('12/03/2014');
            expect(collection.at(1).get('date')).toEqual('12/04/2014');
            expect(collection.at(2).get('date')).toEqual('12/06/2014');
        });

        it('returns a boolean for whether collection hasDate()', function () {
            expect(collection.hasDate('12/01/2014')).toBe(false);
            expect(collection.hasDate('12/04/2014')).toBe(true);
        });
    });
});
